import 'package:nb_utils/nb_utils.dart';

import '../app_common.dart';

extension NumExtension on num {
  String toPriceFormat() {
    return "${isCurrencyPositionLeft ? appCurrency.value.currencySymbol : ''}${this.toStringAsFixed(appCurrency.value.noOfDecimal).formatNumberWithComma()}${isCurrencyPositionRight ? appCurrency.value.currencySymbol : ''}";
  }

  num calculatePercentage(int discount) {
    return this.validate() - (this.validate() * discount / 100);
  }
}
